@echo off
title Python Package Installer
echo ==============================================
echo   Installing and Updating Python modules
echo ==============================================
echo.

REM --- Check if Python is installed ---
python --version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] Python not found!
    echo Please install Python and make sure "Add to PATH" is enabled.
    powershell -command "Add-Type -AssemblyName PresentationFramework; [System.Windows.MessageBox]::Show('Python is not installed or not in PATH.`nPlease install Python with Add to PATH enabled.','Python Installer Error','OK','Error')"
    pause
    exit /b
)

echo Upgrading pip...
python -m pip install --upgrade pip

echo.
echo Installing or upgrading required packages...
echo ==============================================
echo.

REM --- Install main packages (except Pillow) ---
python -m pip install --upgrade tkcalendar requests pyserial

if %errorlevel% neq 0 (
    echo [ERROR] Failed installing basic packages.
    goto fail
)

echo.
echo Installing Pillow (normal method)...
python -m pip install --upgrade Pillow

if %errorlevel% neq 0 (
    echo.
    echo Normal Pillow install failed. Trying pre-release build...
    python -m pip install --pre --upgrade Pillow
)

if %errorlevel% neq 0 (
    echo.
    echo [ERROR] Pillow installation failed.
    goto fail
)

goto success

:success
echo.
echo ==============================================
echo   All required packages are installed!
echo ==============================================

powershell -command "Add-Type -AssemblyName PresentationFramework; [System.Windows.MessageBox]::Show('All required Python packages have been installed and are up-to-date!','Installation Complete','OK','Information')"
exit /b

:fail
echo.
echo [ERROR] One or more packages failed to install.
powershell -command "Add-Type -AssemblyName PresentationFramework; [System.Windows.MessageBox]::Show('One or more packages failed to install or update.','Installation Error','OK','Error')"
pause
exit /b
